/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;

public class VWPreferencesDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener {
    private static final Dimension DIM_DEFAULT_SIZE = new Dimension(425, 425);
    public static final int SELECT_DISPLAY_TAB = 0;
    public static final int SELECT_WORKFLOW_TAB = 1;
    private JTabbedPane m_tabbedPane = null;
    private JCheckBox m_stepNameCheckBox = null;
    private JCheckBox m_routeNameCheckBox = null;
    private JCheckBox m_paintPageBoundaryCkBox = null;
    private JCheckBox m_textAnnotationCheckBox = null;
    private JCheckBox m_milestoneCheckBox = null;
    private JCheckBox m_conditionCheckBox = null;
    private JCheckBox m_collectorCheckBox = null;
    private JComboBox m_bgColorCombo = null;
    private JRadioButton m_stepsInNewRadioButton = null;
    private JRadioButton m_stepsInSameRadioButton = null;
    private JRadioButton m_routesInNewRadioButton = null;
    private JRadioButton m_routesInSameRadioButton = null;
    private JRadioButton m_textAnnosInNewRadioButton = null;
    private JRadioButton m_textAnnosInSameRadioButton = null;
    private JRadioButton m_associationsInNewRadioButton = null;
    private JRadioButton m_associationsInSameRadioButton = null;
    private JCheckBox m_validateCheckBox = null;
    private JCheckBox m_addCheckInCheckBox = null;
    private JCheckBox m_enableInheritanceCheckBox = null;
    private VWDesignerPreferences m_designerPrefs = null;

    public VWPreferencesDialog(VWDesignerCoreData designerCoreData, int nTabToShow) {
        super(designerCoreData.getParentFrame());
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.setTitle(VWResource.s_preferencesDialogTitle);
            this.setSize(DIM_DEFAULT_SIZE);
            this.m_tabbedPane = new JTabbedPane();
            this.m_tabbedPane.setTabPlacement(1);
            JPanel tabPanel = this.getDisplayPanel(designerCoreData.getSessionInfo().getDisplayP8BPMFunctionality());
            if (tabPanel != null) {
                this.m_tabbedPane.addTab(VWResource.s_displayTab, tabPanel);
                if (nTabToShow == 0) {
                    this.m_tabbedPane.setSelectedComponent(tabPanel);
                }
            }
            if (designerCoreData.getApplicationMode() == 1 && (tabPanel = this.getWorkflowPanel(designerCoreData.getSessionInfo().getCanSaveToDMS())) != null) {
                this.m_tabbedPane.addTab(VWResource.s_workflowsTab, tabPanel);
                if (nTabToShow == 1) {
                    this.m_tabbedPane.setSelectedComponent(tabPanel);
                }
            }
            this.getContentPane().add((Component)this.m_tabbedPane, "Center");
            VWDialogButtons dialogButtons = new VWDialogButtons(35);
            dialogButtons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)dialogButtons, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWDesignerPreferences designerPrefs) {
        this.m_designerPrefs = designerPrefs;
        VWMapAttribs mapAttribs = this.m_designerPrefs.getMapAttributes();
        if (this.m_stepNameCheckBox != null) {
            this.m_stepNameCheckBox.setSelected(mapAttribs.isStepNameVisible());
        }
        if (this.m_routeNameCheckBox != null) {
            this.m_routeNameCheckBox.setSelected(mapAttribs.isRouteNameVisible());
        }
        if (this.m_paintPageBoundaryCkBox != null) {
            this.m_paintPageBoundaryCkBox.setSelected(mapAttribs.isPageBoundaryVisible());
        }
        if (this.m_textAnnotationCheckBox != null) {
            this.m_textAnnotationCheckBox.setSelected(mapAttribs.isTextAnnotationsVisible());
        }
        if (this.m_milestoneCheckBox != null) {
            this.m_milestoneCheckBox.setSelected(mapAttribs.isMilestoneVisible());
        }
        if (this.m_conditionCheckBox != null) {
            this.m_conditionCheckBox.setSelected(mapAttribs.isConditionAttrsVisible());
        }
        if (this.m_collectorCheckBox != null) {
            this.m_collectorCheckBox.setSelected(mapAttribs.isCollectorAttrsVisible());
        }
        if (this.m_bgColorCombo != null) {
            this.m_bgColorCombo.setSelectedItem(mapAttribs.getTextAnnotationDefaultBgColor());
        }
        if (this.m_stepsInNewRadioButton != null && this.m_stepsInSameRadioButton != null) {
            if (this.m_designerPrefs.getUseSameStepPropertyTab()) {
                this.m_stepsInSameRadioButton.setSelected(true);
            } else {
                this.m_stepsInNewRadioButton.setSelected(true);
            }
        }
        if (this.m_routesInNewRadioButton != null && this.m_routesInSameRadioButton != null) {
            if (this.m_designerPrefs.getUseSameRoutePropertyTab()) {
                this.m_routesInSameRadioButton.setSelected(true);
            } else {
                this.m_routesInNewRadioButton.setSelected(true);
            }
        }
        if (this.m_textAnnosInNewRadioButton != null && this.m_textAnnosInSameRadioButton != null) {
            if (this.m_designerPrefs.getUseSameTextAnnotationPropertyTab()) {
                this.m_textAnnosInSameRadioButton.setSelected(true);
            } else {
                this.m_textAnnosInNewRadioButton.setSelected(true);
            }
        }
        if (this.m_associationsInNewRadioButton != null && this.m_associationsInSameRadioButton != null) {
            if (this.m_designerPrefs.getUseSameAssociationPropertyTab()) {
                this.m_associationsInSameRadioButton.setSelected(true);
            } else {
                this.m_associationsInNewRadioButton.setSelected(true);
            }
        }
        if (this.m_validateCheckBox != null) {
            this.m_validateCheckBox.setSelected(this.m_designerPrefs.getShouldValidateBeforeTransfer());
        }
        if (this.m_addCheckInCheckBox != null) {
            this.m_addCheckInCheckBox.setSelected(this.m_designerPrefs.getShouldAddCheckIn());
        }
        if (this.m_enableInheritanceCheckBox != null) {
            this.m_enableInheritanceCheckBox.setSelected(this.m_designerPrefs.getShouldDisplayInheritedInformation());
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.performOKAction();
                break;
            }
            case 2: {
                this.performCancelAction();
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    private JPanel getDisplayPanel(boolean bDisplayP8BPMFunctionality) {
        try {
            JPanel displayPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            displayPanel.add((Component)this.getShowOptionsPanel(), gbCons);
            if (bDisplayP8BPMFunctionality) {
                ++gbCons.gridx;
                displayPanel.add((Component)this.getTextAnnotationsOptionsPanel(), gbCons);
            }
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            displayPanel.add((Component)this.getTabOptionsPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            displayPanel.add((Component)new JLabel(" "), gbCons);
            return displayPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getShowOptionsPanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_showOnMap);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 5, 0, 15);
            this.m_stepNameCheckBox = new JCheckBox(VWResource.s_stepNames);
            clientPanel.add((Component)this.m_stepNameCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_routeNameCheckBox = new JCheckBox(VWResource.s_routeNames);
            clientPanel.add((Component)this.m_routeNameCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_paintPageBoundaryCkBox = new JCheckBox(VWResource.s_pageBoundaries);
            clientPanel.add((Component)this.m_paintPageBoundaryCkBox, gbCons);
            ++gbCons.gridy;
            this.m_textAnnotationCheckBox = new JCheckBox(VWResource.s_textAnnotations);
            clientPanel.add((Component)this.m_textAnnotationCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_milestoneCheckBox = new JCheckBox(VWResource.s_milestoneIcons);
            clientPanel.add((Component)this.m_milestoneCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_conditionCheckBox = new JCheckBox(VWResource.s_conditionalRouteIcons);
            clientPanel.add((Component)this.m_conditionCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_collectorCheckBox = new JCheckBox(VWResource.s_collectorStepIcons);
            clientPanel.add((Component)this.m_collectorCheckBox, gbCons);
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getTextAnnotationsOptionsPanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_textAnnotationDefaultColor);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_bgColorCombo = new JComboBox<Color>(VWColorListCellRenderer.getAvailableColors());
            this.m_bgColorCombo.setRenderer(new VWColorListCellRenderer());
            clientPanel.add((Component)this.m_bgColorCombo, "First");
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getTabOptionsPanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_tabsCanDisplay);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 5, 3, 15);
            ButtonGroup buttonGrp1 = new ButtonGroup();
            clientPanel.add((Component)new JLabel(VWResource.s_steps), gbCons);
            ++gbCons.gridx;
            this.m_stepsInNewRadioButton = new JRadioButton(VWResource.s_inNewTab);
            buttonGrp1.add(this.m_stepsInNewRadioButton);
            clientPanel.add((Component)this.m_stepsInNewRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_stepsInSameRadioButton = new JRadioButton(VWResource.s_inSameTab);
            buttonGrp1.add(this.m_stepsInSameRadioButton);
            clientPanel.add((Component)this.m_stepsInSameRadioButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            ButtonGroup buttonGrp2 = new ButtonGroup();
            clientPanel.add((Component)new JLabel(VWResource.s_routes), gbCons);
            ++gbCons.gridx;
            this.m_routesInNewRadioButton = new JRadioButton(VWResource.s_inNewTab);
            buttonGrp2.add(this.m_routesInNewRadioButton);
            clientPanel.add((Component)this.m_routesInNewRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_routesInSameRadioButton = new JRadioButton(VWResource.s_inSameTab);
            buttonGrp2.add(this.m_routesInSameRadioButton);
            clientPanel.add((Component)this.m_routesInSameRadioButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            ButtonGroup buttonGrp3 = new ButtonGroup();
            clientPanel.add((Component)new JLabel(VWResource.s_textAnnotations), gbCons);
            ++gbCons.gridx;
            this.m_textAnnosInNewRadioButton = new JRadioButton(VWResource.s_inNewTab);
            buttonGrp3.add(this.m_textAnnosInNewRadioButton);
            clientPanel.add((Component)this.m_textAnnosInNewRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_textAnnosInSameRadioButton = new JRadioButton(VWResource.s_inSameTab);
            buttonGrp3.add(this.m_textAnnosInSameRadioButton);
            clientPanel.add((Component)this.m_textAnnosInSameRadioButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            ButtonGroup buttonGrp4 = new ButtonGroup();
            clientPanel.add((Component)new JLabel(VWResource.s_associations), gbCons);
            ++gbCons.gridx;
            this.m_associationsInNewRadioButton = new JRadioButton(VWResource.s_inNewTab);
            buttonGrp4.add(this.m_associationsInNewRadioButton);
            clientPanel.add((Component)this.m_associationsInNewRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_associationsInSameRadioButton = new JRadioButton(VWResource.s_inSameTab);
            buttonGrp4.add(this.m_associationsInSameRadioButton);
            clientPanel.add((Component)this.m_associationsInSameRadioButton, gbCons);
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getWorkflowPanel(boolean bCanSaveToDMS) {
        try {
            JPanel workflowPanel = new JPanel(new GridBagLayout());
            workflowPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 5);
            this.m_validateCheckBox = new JCheckBox(VWResource.s_validateBeforeLaunchTransfer);
            workflowPanel.add((Component)this.m_validateCheckBox, gbCons);
            if (bCanSaveToDMS) {
                ++gbCons.gridy;
                this.m_addCheckInCheckBox = new JCheckBox(VWResource.s_addCheckInBeforeLaunchTransfer);
                workflowPanel.add((Component)this.m_addCheckInCheckBox, gbCons);
            }
            ++gbCons.gridy;
            this.m_enableInheritanceCheckBox = new JCheckBox(VWResource.s_enableInheritance);
            workflowPanel.add((Component)this.m_enableInheritanceCheckBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            workflowPanel.add((Component)new JLabel(""), gbCons);
            return workflowPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void performOKAction() {
        this.m_nExitStatus = 0;
        this.setVisible(false);
        VWMapAttribs mapAttribs = this.m_designerPrefs.getMapAttributes();
        mapAttribs.setStepNameVisible(this.m_stepNameCheckBox.isSelected());
        mapAttribs.setRouteNameVisible(this.m_routeNameCheckBox.isSelected());
        mapAttribs.setPageBoundaryVisible(this.m_paintPageBoundaryCkBox.isSelected());
        mapAttribs.setTextAnnotationsVisible(this.m_textAnnotationCheckBox.isSelected());
        mapAttribs.setMilestoneVisible(this.m_milestoneCheckBox.isSelected());
        mapAttribs.setConditionAttrsVisible(this.m_conditionCheckBox.isSelected());
        mapAttribs.setCollectorAttrsVisible(this.m_collectorCheckBox.isSelected());
        if (this.m_bgColorCombo != null) {
            mapAttribs.setTextAnnotationDefaultBgColor((Color)this.m_bgColorCombo.getSelectedItem());
        }
        if (this.m_validateCheckBox != null) {
            this.m_designerPrefs.setShouldValidateBeforeTransfer(this.m_validateCheckBox.isSelected());
        }
        if (this.m_addCheckInCheckBox != null) {
            this.m_designerPrefs.setShouldAddCheckIn(this.m_addCheckInCheckBox.isSelected());
        }
        if (this.m_enableInheritanceCheckBox != null) {
            this.m_designerPrefs.setShouldDisplayInheritedInformation(this.m_enableInheritanceCheckBox.isSelected());
        }
        if (this.m_stepsInSameRadioButton != null) {
            this.m_designerPrefs.setUseSameStepPropertyTab(this.m_stepsInSameRadioButton.isSelected());
        }
        if (this.m_routesInSameRadioButton != null) {
            this.m_designerPrefs.setUseSameRoutePropertyTab(this.m_routesInSameRadioButton.isSelected());
        }
        if (this.m_textAnnosInSameRadioButton != null) {
            this.m_designerPrefs.setUseSameTextAnnotationPropertyTab(this.m_textAnnosInSameRadioButton.isSelected());
        }
        if (this.m_associationsInSameRadioButton != null) {
            this.m_designerPrefs.setUseSameAssociationPropertyTab(this.m_associationsInSameRadioButton.isSelected());
        }
    }

    private void performCancelAction() {
        this.m_nExitStatus = 1;
        this.setVisible(false);
    }

    private void performHelpAction() {
        String helpString = null;
        int index = this.m_tabbedPane.getSelectedIndex();
        String tabName = this.m_tabbedPane.getTitleAt(index);
        if (VWStringUtils.compare(tabName, VWResource.s_displayTab) == 0) {
            helpString = VWHelp.Help_Process_Designer + "bpfdh033.htm";
        } else if (VWStringUtils.compare(tabName, VWResource.s_workflowsTab) == 0) {
            helpString = VWHelp.Help_Process_Designer + "bpfdh035.htm";
        }
        VWHelp.displayPage(helpString);
    }
}

